<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?id=34&alias=linee-guida-per-l%2527uso-del-logo-geecom
    * 
    * Controller dei Gruppi
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../classi/Gruppo.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    // le impostazioni servono per ottenere l'indirizzo del sito da inviare al server
    $impostazioni = $geecomDb->leggiSingolaRiga("geecAd_impostazioni", 1);
    
    session_start();
    controlloAccessoAdmin();
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $gruppo = new Gruppo($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $gruppo = new Gruppo($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $gruppo->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $gruppo->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $idGruppo = $gruppo->crea();
            if($idGruppo>0) {            
                echo $gruppo->stampaElementoGruppo();
            }
            else {
                echo "Errore: esiste già un gruppo con questo nome";
            }
            break;
        case 'modifica':
            $gruppo->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $gruppo->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $gruppo->modifica();
            echo "ok";
            break;
        case 'elimina':
            $gruppo->elimina();
            echo "ok";
            break;
        case 'stampaGruppi':
            $query    = "SELECT * FROM geec_gruppi ORDER BY id DESC";
            $risQuery = $geecomDb->eseguiQueryLettura($query);
            while($datiGruppo = $risQuery->fetch_assoc()) {
                $gruppo->setId($datiGruppo["id"]);
                $gruppo->stampaElementoGruppo();
            }
            break;
    }
